<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Grade extends Model 
{

    protected $table = 'grade';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function getSection()
    {
        return $this->hasMany('App\Model\Section');
    }

    public function getSubject()
    {
        return $this->belongsToMany('App\Model\Subject');
    }

}